package jamezo97.clonecraft.gui;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotType extends Slot{

	
	private int itemID, itemDamage, stackSizeMax;
	
	/**
	 * 
	 * @param par1iInventory
	 * @param par2
	 * @param par3
	 * @param par4
	 * @param itemID Id of the item allowed.
	 * @param itemDamage Damage value of the item allowed (-1 for unapplicable)
	 */
	public SlotType(IInventory par1iInventory, int par2, int par3, int par4, int itemID, int itemDamage, int stackSizeMax) {
		super(par1iInventory, par2, par3, par4);
		this.itemID = itemID;
		this.itemDamage = itemDamage;
		this.stackSizeMax = stackSizeMax;
	}
	
	

	@Override
	public int getSlotStackLimit() {
		return stackSizeMax;
	}



	@Override
	public boolean isItemValid(ItemStack stack) {
		return stack.getItem().itemID == itemID && (itemDamage > -1?itemDamage == stack.getItemDamage():true);
	}
	
	

}
